/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.GameWindow;
import core.GameWindowCallbackIf;
import core.enums.State;
import core.states.GameState;
import core.states.MainMenuState;
import java.awt.Dimension;
import org.lwjgl.Sys;
import util.AudioManager;
import util.ResourceManager;

public class MinionInvaders
implements GameWindowCallbackIf {
    private boolean vsync = true;
    private int maxFps = 60;
    private int width = 800;
    private int height = 600;
    private String windowTitle = "MinionInvaders 1.3.7";
    private State state = State.MAIN_MENU;
    private GameWindow window = null;
    private int fps;
    private long lastFpsTime = 0L;
    private long lastGarbageCollectionTime = 0L;
    private long lastLoopTime = 0L;

    public MinionInvaders() {
        ResourceManager.get().setGame(this);
        this.window = ResourceManager.get().getGameWindow();
        this.window.setResolution(this.width, this.height);
        this.window.setGameWindowCallback(this);
        this.window.setIcons(new String[]{"/resources/icons/icon16.png", "/resources/icons/icon32.png", "/resources/icons/icon64.png", "/resources/icons/icon128.png"});
        this.window.setTitle(this.windowTitle);
        this.window.setFramerate(this.maxFps);
        this.window.setVsync(this.vsync);
        this.window.startRendering();
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public void setState(State state) {
        this.state = state;
        if (state == State.GAME) {
            GameState.get().startGame();
        } else if (state == State.MAIN_MENU) {
            MainMenuState.get().reinit();
        }
    }

    @Override
    public void initialise() {
        ResourceManager.get().initAudio();
    }

    public long getSystemTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    @Override
    public void frameRendering() {
        long delta = this.getSystemTime() - this.lastLoopTime;
        this.lastLoopTime = this.getSystemTime();
        this.lastFpsTime += delta;
        ++this.fps;
        if (this.lastFpsTime >= 1000L) {
            this.window.setTitle(String.valueOf(this.windowTitle) + " (FPS: " + this.fps + ")");
            this.lastFpsTime = 0L;
            this.fps = 0;
        }
        if (this.lastGarbageCollectionTime == 0L || this.lastGarbageCollectionTime + 5000L < this.getSystemTime()) {
            this.lastGarbageCollectionTime = this.getSystemTime();
            Runtime.getRuntime().gc();
        }
        ResourceManager.get().playMusic("lol_retro");
        AudioManager.get().poll();
        switch (this.state) {
            case MAIN_MENU: {
                MainMenuState.get().render(delta);
                break;
            }
            case GAME: {
                GameState.get().render(delta);
            }
        }
    }

    public void sleep(long duration) {
        if (!this.window.displayReady()) {
            return;
        }
        try {
            Thread.sleep(duration * Sys.getTimerResolution() / 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void windowClosed() {
        ResourceManager.get().cleanUp();
        System.exit(0);
    }
}

